	function [b,c] = imp2tf(hl);
	
	% Berechnung der Uebertragungsfunktion aus der Impulsantwort;
	% -----------------------------------------------------------
	% Das Programm [b,c] = imp2tf(hl) berechnet aus l Werten der
	% Impulsantwort hl(k) eines Systems ie Koeffizienten des 
	% Zaehler- und des Nennerpolynoms der zugehoerigen Ueber-
	% tragungsfunktion vom Grad n <= fix(l/2);
	%
	% Lit.: Schuessler: DSV1 Abschn. 5.3.2;
	
	hl = hl(:); l = length(hl);
	
	% Hankelsche Matrix generieren; n = Systemgrad:
	l1 = fix(l/2); S = hankel(hl(2:l1+1),hl(l1+1:2*l1));
	n = rank(S);
	
	% Nennerkoeffizienten:
	Hc = S(1:n,1:n); h = hl(n+2:2*n+1);
	c = -Hc\h; c = [1 fliplr(c')]';
	
	% Zaehlerkoeffizienten;
	Hb = toeplitz(hl(1:n+1),[hl(1) zeros(1,n)]);
	b = Hb*c;
